% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonstdMetrics.R
\name{ser}
\alias{ser}
\title{Non-Standard Evaluation Metrics}
\usage{
ser(trues, preds, phi.trues = NULL, ph = NULL, t = 0)
}
\arguments{
\item{trues}{Target values from a test set of a given data set. Should be a vector and have the same size as the variable preds}

\item{preds}{Predicted values given a certain test set of a given data set. Should be a vector and have the same size as the variable preds}

\item{phi.trues}{Relevance of the values in the parameter trues. Use ??phi() for more information. Defaults to NULL}

\item{ph}{The relevance function providing the data points where the pairs of values-relevance are known. Default is NULL}

\item{t}{Relevance cut-off. Default is 0.}
}
\value{
Squared error for for cases where the relevance of the true value is greater than t (SERA)
}
\description{
Obtains the squared error of predictions for a given subset of relevance
}
\details{
Squared Error-Relevance Metric (SER)
}
\examples{
library(IRon)

if(requireNamespace("rpart",quietly=TRUE)) {

   data(accel)

   form <- acceleration ~ .

   ind <- sample(1:nrow(accel),0.75*nrow(accel))

   train <- accel[ind,]
   test <- accel[-ind,]

   ph <- phi.control(accel$acceleration)

   m <- rpart::rpart(form, train)
   preds <- as.vector(predict(m,test))

   trues <- test$acceleration
   phi.trues <- phi(test$acceleration,ph)

   ser(trues,preds,phi.trues)

}

}
