% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_toy_net.R
\encoding{UTF-8}
\name{build_toy_net}
\alias{build_toy_net}
\title{Generating an example tripartite network randomly}
\usage{
build_toy_net(N_a, N_b, N_c, Co, output_matrices = FALSE)
}
\arguments{
\item{N_a}{The number of nodes in the a-node group.}

\item{N_b}{The number of nodes in the b-node group.}

\item{N_c}{The number of nodes in the c-node group.}

\item{Co}{The probability of creating a link between any two nodes. It ranges from 0 to 1.}

\item{output_matrices}{Logical. Whether to output the entire adjacency matrix of the network and subnetworks. Defaults to FALSE.}
}
\value{
Return a random binary tripartite network.
}
\description{
Generate a binary tripartite network with three groups of nodes (a-, b- and c-nodes) and two subnetworks (P and Q). Subnetwork P contains links between a- and b-nodes; Subnetwork Q contains links between b- and c-nodes;b-nodes (some of which are connector nodes) are shared nodes between two subnetworks.
}
\examples{

set.seed(12)
Net <- build_toy_net(11,15,16,0.2)
plot(Net)

set.seed(12)
Net <- build_toy_net(11,15,16,0.2,output_matrices=TRUE)
Net

}
\references{
Pilosof, S., Porter, M., Pascual, M. et al. The multilayer nature of ecological networks. Nat Ecol Evol 1, 0101 (2017). https://doi.org/10.1038/s41559-017-0101
}
