% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AAEA.R
\name{AAEA}
\alias{AAEA}
\title{Average annual number of events analysis}
\usage{
AAEA(Time_series,MaxIETD,xlabel,ylabel)
}
\arguments{
\item{Time_series}{A dataframe. The first column contains the time and day of a rainfall pulse and the second one the depth
of rainfall in each time step. The date must be as POSIXct class.}

\item{MaxIETD}{The maximum value of IETD to be analyzed (in hours). Default value 24.}

\item{xlabel}{Label of the x-axis.}

\item{ylabel}{Label of the y-axis.}
}
\value{
A list with the figure of IETD (in hours) vs AAE and a dataframe with its values.
}
\description{
This function provides the required figure to define the inter-event time definition (IETD) based on
the average annual number of events analysis.
}
\details{
This analysis is based on the computation of the average annual number of events (AAE) for several IETD values, the appropriate value
of IETD is determined as the point where increasing IETD does not change AAE significantly \insertCite{Joo2014,Adams2000}{IETD}.
The analyst, thus, uses the plot of IETD vs AAE to define that value.
}
\note{
To review the concept of IETD, go to the details of  \code{\link{drawre}} function.
}
\examples{
AAEA(Time_series=hourly_time_series)
}
\references{
\insertAllCited{}
}
\author{
Luis F. Duque <lfduquey@gmail.com> <l.f.duque-yaguache2@newcastle.ac.uk>
}
