% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialfuncs.r
\name{get.tau.permute}
\alias{get.tau.permute}
\title{get the null distribution of the \code{get.tau} function}
\usage{
get.tau.permute(
  posmat,
  fun,
  r = 1,
  r.low = rep(0, length(r)),
  permutations,
  comparison.type = "representative",
  data.frame = TRUE
)
}
\arguments{
\item{posmat}{a matrix appropriate for input to \code{get.tau}}

\item{fun}{a function appropriate for input to \code{get.tau}}

\item{r}{the series of spatial distances we are interested in}

\item{r.low}{the low end of each range....0  by default}

\item{permutations}{the number of permute iterations}

\item{comparison.type}{the comparison type to pass as input to \code{get.pi}}

\item{data.frame}{logical indicating whether to return results as a data frame (default = TRUE)}
}
\value{
tau values for all the distances we looked at
}
\description{
Does permutations to calculate the null distribution of get pi
if there were no spatial dependence. Randomly reassigns coordinates
to each observation permutations times
}
\examples{
\donttest{

#compare normally distributed with uniform points
x<-cbind(1,runif(100,-100,100), runif(100,-100,100))
x<-rbind(x, cbind(2,rnorm(100,0,20), rnorm(100,0,20)))
colnames(x) <- c("type","x","y")

fun<-function(a,b) {
    if(a[1]!=2) return(3)
    if (b[1]==2) return(1)
    return(2)
}

r.max<-seq(10,100,10)
r.min<-seq(0,90,10)
r.mid <- (r.max+r.min)/2

tau<-get.tau(x,fun,r=r.max,r.low=r.min,comparison.type = "independent")
tau.null<-get.tau.permute(x,fun,r=r.max,r.low=r.min,permutations=50,comparison.type = "independent")

null.ci<-apply(tau.null[,-(1:2)],1,quantile,probs=c(0.25,0.75))

plot(r.mid, tau$tau, ylim=c(1/max(tau$tau),max(tau$tau)), type="l", log="y")
lines(c(0,100),c(1,1), lty=3, col="grey")
lines(r.mid, null.ci[1,] , lty=2)
lines(r.mid, null.ci[2,] , lty=2)

}
}
\seealso{
Other get.tau: 
\code{\link{get.tau}()},
\code{\link{get.tau.bootstrap}()},
\code{\link{get.tau.ci}()},
\code{\link{get.tau.typed}()},
\code{\link{get.tau.typed.bootstrap}()},
\code{\link{get.tau.typed.permute}()}
}
\author{
Justin Lessler and Henrik Salje
}
\concept{get.tau}
