% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialfuncs.r
\name{get.tau.bootstrap}
\alias{get.tau.bootstrap}
\title{Bootstrap \code{get.tau} values.}
\usage{
get.tau.bootstrap(
  posmat,
  fun,
  r = 1,
  r.low = rep(0, length(r)),
  boot.iter,
  comparison.type = "representative",
  data.frame = TRUE
)
}
\arguments{
\item{posmat}{a matrix appropriate for input to \code{get.tau}}

\item{fun}{a function appropriate as input to \code{get.pi}}

\item{r}{the series of spatial distances wer are interested in}

\item{r.low}{the low end of each range....0  by default}

\item{boot.iter}{the number of bootstrap iterations}

\item{comparison.type}{the comparison type to pass as input to \code{get.pi}}

\item{data.frame}{logical indicating whether to return results as a data frame (default = TRUE)}
}
\value{
a matrix containing all bootstrapped values of tau for each distance interval
}
\description{
Runs \code{get.tau} on multiple bootstraps of the data. Is formulated
such that the relationship between points and themselves will not be
calculated
}
\examples{
\donttest{

#compare normally distributed with uniform points
x<-cbind(1,runif(100,-100,100), runif(100,-100,100))
x<-rbind(x, cbind(2,rnorm(100,0,20), rnorm(100,0,20)))
colnames(x) <- c("type","x","y")

fun<-function(a,b) {
    if(a[1]!=2) return(3)
    if (b[1]==2) return(1)
    return(2)
}

r.max<-seq(10,100,10)
r.min<-seq(0,90,10)
r.mid <- (r.max+r.min)/2

tau<-get.tau(x,fun,r=r.max,r.low=r.min)
tau.boot<-get.tau.bootstrap(x,fun,r=r.max,r.low=r.min,boot.iter=50)

tau.ci<-apply(tau.boot[,-(1:2)],1,quantile,probs=c(0.25,0.75))

plot(r.mid, tau$tau ,ylim=c(min(tau.ci),max(tau.ci)), type="l", log="y")
lines(c(0,100),c(1,1), lty=3, col="grey")
lines(r.mid, tau.ci[1,] , lty=2)
lines(r.mid, tau.ci[2,] , lty=2)

}
}
\seealso{
Other get.tau: 
\code{\link{get.tau}()},
\code{\link{get.tau.ci}()},
\code{\link{get.tau.permute}()},
\code{\link{get.tau.typed}()},
\code{\link{get.tau.typed.bootstrap}()},
\code{\link{get.tau.typed.permute}()}
}
\author{
Justin Lessler and Henrik Salje
}
\concept{get.tau}
