% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backfitter.R
\name{backfitter}
\alias{backfitter}
\title{Backfitting for Additive Models}
\usage{
backfitter(
  X,
  y,
  predictor,
  fitMethod,
  predictfcn,
  eps = 0.01,
  iter.max = 10,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{X}{The design matrix.}

\item{y}{The response vector.}

\item{predictor}{The name or index of the predictor of interest (\eqn{x_S}).}

\item{fitMethod}{A function that accepts \code{X} and \code{y} and returns a fitted model.}

\item{predictfcn}{A function that accepts \code{object} and \code{newdata} and returns predictions.}

\item{eps}{Convergence threshold.}

\item{iter.max}{Maximum number of iterations.}

\item{verbose}{If \code{TRUE}, prints progress messages.}

\item{...}{Additional arguments passed to \code{fitMethod}.}
}
\value{
An object of class \code{backfitter}.
}
\description{
Fits a model of the form \eqn{\hat{f}(x) = \hat{g}_{1}(x_S) + \hat{g}_{2}(x_C)} using backfitting.
}
