% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VAM.R
\name{VAM}
\alias{VAM}
\title{Vogel's Approximation Method}
\usage{
VAM(ex_matrix)
}
\arguments{
\item{ex_matrix}{A cost matrix where last column must be the supply and last row must be the demand. Input matrix should not have any missing values (NA), otherwise function will throw an error. It should be balanced i.e. total demand must be equal to total supply.}
}
\value{
A List which contain the allocation matrix and the total optimized cost.
}
\description{
Vogel's approximation method is preferred over NWCM and LCM methods. In this method allocation is made on the basis of the opportunity cost that would have been incurred if the allocation in certain cells with minimum unit transportation cost were missed. Hence, allocations are made in such a way that the penelty cost is minimized. An initial solution obtained by using this method is nearer to an optimal solution or is the optimal solution itself.
}
\examples{
#Input matrix where last row is the Demand and last column is the Supply
ex_matrix=data.frame(D1=c(6,3,4,20),E1=c(4,8,4,95),F1=c(1,7,2,35),
                     Supply=c(50,40,60,150),row.names = c("A1","B1","C1","Demand"))
VAM(ex_matrix)

}
