% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NWCM.R
\name{NWCM}
\alias{NWCM}
\title{North-West Corner Method}
\usage{
NWCM(ex_matrix)
}
\arguments{
\item{ex_matrix}{A cost matrix where last column must be the supply and last row must be the demand. Input matrix should not have any missing values (NA), otherwise function will throw an error. It should be balanced i.e. total demand must be equal to total supply.}
}
\value{
A List which contain the allocation matrix and the total optimized cost.
}
\description{
This method does not take into account the cost of transportation on any route of transportation.
}
\examples{
#Input matrix where last row is the Demand and last column is the Supply
ex_matrix=data.frame(D1=c(6,3,4,20),E1=c(4,8,4,95),F1=c(1,7,2,35),
                     Supply=c(50,40,60,150),row.names = c("A1","B1","C1","Demand"))
NWCM(ex_matrix)

}
