% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{add_Genes}
\alias{add_Genes}
\title{Add gene information}
\usage{
add_Genes(df, speciesObj)
}
\arguments{
\item{df}{The ModuleSummary data frame obtained by running hic2community function}

\item{speciesObj}{Any Txdb package name corresponding}
}
\value{
A \code{data.frame} identical to the input, with an additional \code{"Genes"} column. Each entry in this column lists the gene(s) that overlap with the corresponding genomic region. If multiple genes are present, they are concatenated with commas.
}
\description{
This function adds a column with a list of genes included in each locus to the ModuleSummary data frame of the hic2community function.
}
\details{
Adding gene list to ModuleSummary data frame obtained from hic2community function.
}
\examples{
modulefile = system.file('extdata','mouse_naiveCD4T_Vahedi_short.rds',
package = 'HiCocietyExample')
mycom = readRDS(modulefile)
mycom$ModuleSummary = add_Genes(mycom$ModuleSummary,
'TxDb.Mmusculus.UCSC.mm10.knownGene')
}
\author{
Sora Yoon, PhD
}
