% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossover.R
\name{hapiCVMap}
\alias{hapiCVMap}
\title{Visualization of crossover map}
\usage{
hapiCVMap(cv, chr = hg19, step = 5, gap = gap.hg19, x.limits = 6,
  y.breaks = NULL, y.labels = NULL)
}
\arguments{
\item{cv}{a dataframe of crossover information}

\item{chr}{a dataframe of chromosome information, including length, 
and centrometric regions}

\item{step}{a numeric value of genomic interval in Mb. 
Default is \code{5}}

\item{gap}{a dataframe of unassembled regions with the first column is
chromosme, the second column is start position, and third column is the 
end position of the gap. Default is gap for hg19. 
If no gap region is provided, use \code{gap=NULL}}

\item{x.limits}{a numeric value of limits on x axis}

\item{y.breaks}{a vector of positions to show labels on y axis. 
Default is \code{NULL}}

\item{y.labels}{a vector of labels on the y axis. Default is \code{NULL}}
}
\value{
a plot of crossover map on all the chromosomes
}
\description{
Visualization of crossover map
}
\examples{
data(crossover)
\donttest{hapiCVMap(cv=crossover)}
}
\author{
Ruidong Li
}
