% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_aggregated_uptake.R
\name{calculate_aggregated_uptake}
\alias{calculate_aggregated_uptake}
\title{Calculates aggregated deuterium uptake for one time point}
\usage{
calculate_aggregated_uptake(
  kin_dat,
  state = unique(kin_dat[["State"]])[1],
  time_t
)
}
\arguments{
\item{kin_dat}{single state uptake data, product of e.q.
\code{\link{create_uptake_dataset}}}

\item{state}{state included in calculations}

\item{time_t}{chosen time point}
}
\value{
a \code{\link{data.frame}} object
}
\description{
Function aggregates the deuterium uptake values from
peptide level into single-amino resolution using `weighted
approach` (defined in `vignette("datafiles"))`. For 
visualization use \code{\link{plot_aggregated_uptake}}
}
\examples{
\donttest{
# disabled due to long execution time 

kin_dat <- create_uptake_dataset(alpha_dat, states = "Alpha_KSCN")
head(create_aggregated_uptake_dataset(kin_dat))
}

}
