% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n_cowan1956.R
\name{n_cowan1956}
\alias{n_cowan1956}
\title{Compute hydraulic roughness following Cowan (1956)}
\usage{
n_cowan1956(
  material,
  irregularity,
  cross,
  obstructions,
  vegetation,
  meandering,
  restrict = TRUE
)
}
\arguments{
\item{material}{channel material (e.g. earth, rock cut, fine gravel, coarse Gravel)}

\item{irregularity}{degree of bed irregularity (e.g. smooth, minor, moderate, severe)}

\item{cross}{variations of channel cross section (e.g. gradual, alternating occasionally, alternating frequently)}

\item{obstructions}{relative effect of obstructions (e.g. negligible, minor, appreciable, severe)}

\item{vegetation}{vegetation (e.g. low, medium, high, very high)}

\item{meandering}{degree of meandering (e.g. minor, appreciable, severe)}

\item{restrict}{allows for function parameters to restrict certain values. Type bool. Default TRUE.}
}
\value{
Manning's n
}
\description{
\code{n_cowan1956} calculate Manning's n using the Cowan Method (1956) for
estimating total channel roughness
}
\examples{
# Result: Manning's n of 0.028
material <- 'Earth'
irregularity <- 'Smooth'
cross <- 'Gradual'
obstructions <- 'Negligible'
vegetation <- 'Low'
meandering <- 'Minor'
n_cowan1956(material,irregularity,cross,obstructions,vegetation,meandering)

# Result: Manning's n of 0.075
material <- 'Rock Cut'
irregularity <- 'Minor'
cross <- 'Alternating occasionally'
obstructions <- 'Minor'
vegetation <- 'Medium'
meandering <- 'Appreciable'
n_cowan1956(material,irregularity,cross,obstructions,vegetation,meandering)

# Result: Manning's n of 0.142
material <- 'Fine Gravel'
irregularity <- 'Moderate'
cross <- 'Alternating frequently'
obstructions <- 'Appreciable'
vegetation <- 'High'
meandering <- 'Severe'
n_cowan1956(material,irregularity,cross,obstructions,vegetation,meandering)

}
\references{
Cowan, W. L. 1956. Estimating Hydraulic Roughness Coefficients. Agricultural
Engineering. ASAE, August, 1956.
Phillips, J. V., and S. Tadayon. 2007. Selection of Manning’s Roughness Coefficient for Natural
and Constructed Vegetated and Non-Vegetated Channels, and Vegetation Maintenance
Plan Guidelines for Vegetated Channels in Central Arizona. Scientific Investigations
Report 2006–5108. USGS, Reston, Virginia.
}
