% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmpv.R
\name{pmpv}
\alias{pmpv}
\title{Permutation p-values}
\usage{
pmpv(Y, X, W = NULL, type, B = 100, fold.num = 10, perm.num = 1000)
}
\arguments{
\item{Y}{A numeric response vector, containing nobs variables.}

\item{X}{An input matrix, of dimension nobs x nvars.}

\item{W}{A covariate matrix, of dimension nobs x ncors, default is NULL.}

\item{type}{Penalized regression type, valid parameters include "Lasso", "AdaLasso", "SCAD", and "MCP".}

\item{B}{Multi-split times, default is 100.}

\item{fold.num}{The number of cross validation folds, default is 10.}

\item{perm.num}{Permutation times, default is 1000.}
}
\value{
A matrix containing harmonic mean p-values from permutation.
}
\description{
Calculates
}
\examples{
set.seed(10)
X <- matrix(rnorm(20000), nrow = 100)
beta <- rep(0, 200)
beta[1:100] <- 5
Y <- MASS::mvrnorm(n = 1, mu = X\%*\%beta, Sigma = diag(100))
result <- pmpv(Y=Y, X=X, type = "Lasso", B = 2, fold.num = 10, perm.num = 10)
}
