% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_model.R
\name{HCR}
\alias{HCR}
\title{Hidden Compact Representation Model}
\usage{
HCR(X, Y, score_type = "bic", is_anm = FALSE, is_cyclic = FALSE,
  verbose = FALSE, max_iteration = 1000, ...)
}
\arguments{
\item{X}{The data of cause.}

\item{Y}{The data of effect.}

\item{score_type}{You can choose "bic","aic","aicc","log" as the type of score to fit the HCR model. Default: bic}

\item{is_anm}{If is_anm=TRUE, it will enable a data preprocessing to adjust for the additive noise model.}

\item{is_cyclic}{If is_anm=TRUE and is_cyclic=TRUE, it will enable a data preprocessing to adjust the cyclic additive noise model.}

\item{verbose}{Show the score at each iteration.}

\item{max_iteration}{The maximum iteration.}

\item{...}{Other arguments passed on to methods. Not currently used.}
}
\value{
The fitted HCR model and its score.
}
\description{
Causal Discovery from Discrete Data using Hidden Compact Representation.
}
\examples{
library(data.table)
set.seed(10)
data=simuXY(sample_size=200)
r1<-HCR(data$X,data$Y)
r2<-HCR(data$Y,data$X)
# The canonical hidden representation
unique(r1$data[,c("X","Yp")])
# The recovery of hidden representation
unique(data.frame(data$X,data$Yp))

}
