% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{matern_categorical}
\alias{matern_categorical}
\alias{d_matern_categorical}
\title{Isotropic Matern covariance function with random effects for categories}
\usage{
matern_categorical(covparms, locs)

d_matern_categorical(covparms, locs)
}
\arguments{
\item{covparms}{A vector with covariance parameters
in the form (variance, range, smoothness, category variance, nugget)}

\item{locs}{A matrix with \code{n} rows and \code{d} columns.
Each row of locs gives a point in R^d.}
}
\value{
A matrix with \code{n} rows and \code{n} columns, with the i,j entry
containing the covariance between observations at \code{locs[i,]} and
\code{locs[j,]}.
}
\description{
From a matrix of locations and covariance parameters of the form
(variance, range, smoothness, category variance, nugget), return the square matrix of
all pairwise covariances.
}
\section{Functions}{
\itemize{
\item \code{d_matern_categorical()}: Derivatives of isotropic Matern covariance

}}
\section{Parameterization}{

The covariance parameter vector is (variance, range, smoothness, category variance, nugget)
= \eqn{(\sigma^2,\alpha,\nu,c^2,\tau^2)}, and the covariance function is parameterized
as
\deqn{ M(x,y) = \sigma^2 2^{1-\nu}/\Gamma(\nu) (|| x - y ||/\alpha )^\nu K_\nu(|| x - y ||/\alpha ) }
The nugget value \eqn{ \sigma^2 \tau^2 } is added to the diagonal of the covariance matrix.
The category variance \eqn{c^2} is added if two observation from same category
NOTE: the nugget is \eqn{ \sigma^2 \tau^2 }, not \eqn{ \tau^2 }.
}

