% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_book_summary.R
\name{get_book_summary}
\alias{get_book_summary}
\title{Get Book Summary from Goodreads}
\usage{
get_book_summary(file_path)
}
\arguments{
\item{file_path}{A character string specifying the path to the file containing Goodreads book IDs.}
}
\value{
A named list where each element contains the summary for a book.
}
\description{
This function takes a file path containing Goodreads book IDs and retrieves
the summary for each book.
}
\examples{
\donttest{
# Create a temporary file with sample book IDs
temp_file <- tempfile(fileext = ".txt")
writeLines(c("1420", "2767052", "10210"), temp_file)
# Run the function
book_summary <- get_book_summary(temp_file)
print(book_summary)
# Clean up: remove the temporary file
file.remove(temp_file)
}
}
