% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_statistics.R
\name{summary_numeric}
\alias{summary_numeric}
\title{Summarizes descriptive statistics for numeric variables}
\usage{
summary_numeric(x, ...)
}
\arguments{
\item{x}{Data frame, matrix, or vector containing numerical variables.}

\item{...}{Additional arguments passed to \code{print_numeric}.}
}
\value{
A tibble with one row per numeric variable and the following columns:
\describe{
\item{Variables}{Character specifying the variable name.}
\item{Median+/-IQR}{Character specifying the median and interquartile range.}
}
}
\description{
Formats the output of \code{print_numeric} into a concise summary.
}
\examples{
x <- data.frame(A = rnorm(100), B = rnorm(100))
summary_numeric(x)
summary_numeric(x, digits = 2, width = 5)

}
