% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_statistics.R
\name{summary_binomial}
\alias{summary_binomial}
\title{Summarizes descriptive statistics for binomial variables}
\usage{
summary_binomial(x, ...)
}
\arguments{
\item{x}{Data frame, matrix, or vector containing binomial variables.}

\item{...}{Additional arguments passed to \code{print_binomial}.}
}
\value{
A tibble with descriptive statistics containing the following columns:
\describe{
\item{Variables}{Character vector specifying the name of each variable.}
\item{Statistics}{Character vector combining the reference level of a variable with its frequency count and its percentage.}
}
}
\description{
Summarizes descriptive statistics for binomial variables
}
\examples{
x <- data.frame(A = sample(c("X", "Y"), 100, replace = TRUE))
summary_binomial(x)
summary_binomial(x, digits = 2, width = 5)

}
