% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2025-10-27_JF_R_Galaxy_functions.R
\name{galaxy_get_tool}
\alias{galaxy_get_tool}
\title{Retrieve detailed metadata for a Galaxy tool}
\usage{
galaxy_get_tool(
  tool_id,
  galaxy_url = "https://usegalaxy.eu",
  tool_version = NULL
)
}
\arguments{
\item{tool_id}{Character. The Galaxy tool identifier (for example
\code{"toolshed.g2.bx.psu.edu/repos/devteam/fastqc/fastqc/0.73"}).}

\item{galaxy_url}{Character. Base URL of the Galaxy instance
(for example \code{"https://usegalaxy.eu"}).
If the environment variable \code{GALAXY_URL} is set, it takes precedence.}

\item{tool_version}{Optional character string to request a specific
version. If \code{NULL}, Galaxy will return the default/latest
version metadata.}
}
\value{
A list containing the tool metadata as returned by the Galaxy
API (inputs, outputs, help text, etc.).
}
\description{
Retrieve detailed metadata for a Galaxy tool
}
\examples{
\dontshow{if (galaxy_has_key()) withAutoprint(\{ # examplesIf}
tool_id <- galaxy_get_tool_id("FastQC")[1]
fastqc_tool <- galaxy_get_tool(tool_id)
fastqc_tool$description
\dontshow{\}) # examplesIf}
}
