% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2026-01-21_s4_class_methods.R
\name{galaxy_run_tool}
\alias{galaxy_run_tool}
\alias{galaxy_run_tool,character-method}
\alias{galaxy_run_tool,Galaxy-method}
\title{Generic run tool}
\usage{
galaxy_run_tool(
  x,
  tool_id,
  inputs = NULL,
  dataset_id = NULL,
  galaxy_url = "https://usegalaxy.eu"
)

\S4method{galaxy_run_tool}{character}(
  x,
  tool_id,
  inputs = NULL,
  dataset_id = NULL,
  galaxy_url = "https://usegalaxy.eu"
)

\S4method{galaxy_run_tool}{Galaxy}(x, tool_id, inputs = NULL, dataset_id = NULL)
}
\arguments{
\item{x}{A history ID (\code{character}) or a \code{Galaxy} object.}

\item{tool_id}{Tool identifier to execute.}

\item{inputs}{Named list of tool inputs.}

\item{dataset_id}{ID of the input dataset (HDA).}

\item{galaxy_url}{Base URL of the Galaxy instance, used by the character
method.}
}
\value{
For the character method, a job ID; for the \code{Galaxy} method, the
modified \code{Galaxy} object.
}
\description{
\code{galaxy_run_tool()} is an S4 generic. With \code{x} as a character vector it is
treated as a history ID; the specified tool is invoked in that history and
the job ID is returned. With \code{x} as a \code{Galaxy} object, the history ID and
URL are taken from the object and the object is updated with the job ID.
}
