% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures_grid.R
\name{measures.grid}
\alias{measures.grid}
\title{Returns dependency measures for a grid type copula}
\usage{
measures.grid(gc, measures = "all")
}
\arguments{
\item{gc}{a grid type copula object.}

\item{measures}{A vector of the measurements to calculate:
"gini", "blomqvist", "tail_U", "tail_L", "rho", "tau","mi",
by default "all".}
}
\value{
A list with dependence measures
}
\description{
Returns dependency measures for a grid type copula
}

\examples{
# Generating simulated data with a transformation to the copula domain
n <- 500
x <- rgamma(n,4,1/2)
e <- rnorm(n,0,.3)
y <- sin(x+e)
Fx <- ecdf(x)
Fy <- ecdf(y)
u <- Fx(x)
v <- Fy(y)
df <- cbind(u,v)
copula.grid <- estimate.gridCopula(U = df, k = 5, m = 4 , method = "ml")
measures.grid(copula.grid) 
measures.grid(copula.grid, measures = c("rho","tau","mi"))

# Using the Iris dataset, transformation is not mandatory
copula.grid <- estimate.gridCopula(X = iris[,1:2], k = 3, m = 7 , method = "ml")
measures.grid(copula.grid, measures = c("gini", "blomqvist", "tail_U", "tail_L", "rho"))
}

\details{
\describe{
  \item{\code{"tau"}}{Kendall's \eqn{\tau}, see Nelsen (2007).}
  
  \item{\code{"rho"}}{Spearman's \eqn{\rho}, see Nelsen (2007).}
  
  \item{\code{"blomqvist"}}{Blomqvist's \eqn{\beta}; computed as \eqn{4C(0.5, 0.5) - 1}, see Nelsen (2007).}
  
  \item{\code{"gini"}}{Gini's \eqn{\gamma}, see Nelsen (2007).}
  
  \item{\code{"mi"}}{Mutual information, see Joe (1989).}
  
  \item{\code{"tail_U/tail_L"}}{Tail dependency, see Nelsen (2007).}
}
}

\references{
Nelsen, R. (2007). An introduction to copulas. Springer Science
& Business Media.

Joe, H. (1989). Relative Entropy Measures of Multivariate Dependence.
Journal of the American Statistical Association.
}

