% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmse_summary.R
\name{gmse_summary}
\alias{gmse_summary}
\title{gmse results summary}
\usage{
gmse_summary(gmse_results)
}
\arguments{
\item{gmse_results}{The full list as returned by the gmse function}
}
\value{
A simplified list that includes four elements, each of which is a table of data: 1. resources, a table showing time step in the first column, followed by resource abundance in the second column. 2. observations, a table showing time step in the first column, followed by the estimate of population size (produced by the manager) in the second column. 3. costs, a table showing time step in the first column, manager number in the second column (should always be zero), followed by the costs of each action set by the manager (policy); the far-right column indicates budget that is unused and therefore not allocated to any policy. 4. actions, a table showing time step in the first column, user number in the second column, followed by the actions of each user in the time step; additional columns indicate unused actions, crop yield on the user's land (if applicable), and the number of resources that a user successfully harvests (i.e., 'culls').
}
\description{
Summarise gmse output in a more user-friendly format
}
\examples{
\dontrun{
sim_summary <- gmse_summary(gmse_results = sim);
}
}
