% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glme.gev.R
\name{glme.like}
\alias{glme.like}
\title{Calculate the likelihood for Generalized L-moments estimation of GEV distribution}
\usage{
glme.like(
  par = par,
  xdat = xdat,
  slmgev = slmgev,
  covinv = covinv,
  lcovdet = lcovdet,
  mu = mu,
  std = std,
  lme = lme,
  pen = pen,
  p = p,
  c1 = c1,
  c2 = c2
)
}
\arguments{
\item{par}{A vector of GEV parameters (location, scale, shape).}

\item{xdat}{A numeric vector of data.}

\item{slmgev}{Sample L-moments of the data.}

\item{covinv}{Inverse of the covariance matrix of the sample L-moments.}

\item{lcovdet}{Log determinant of the covariance matrix.}

\item{mu}{Mean for the normal penalization (used when pen='norm').}

\item{std}{Standard deviation for the normal penalization (used when pen='norm').}

\item{lme}{L-moment estimates of the parameters.}

\item{pen}{Penalization method: 'norm', 'beta', 'ms', 'park', 'cannon', 'cd', or 'no'.}

\item{p}{Shape parameter for beta penalty.}

\item{c1}{Scaling parameter for beta penalty.}

\item{c2}{Upper limit parameter for beta penalty.}
}
\value{
A numeric value representing the penalized negative log-likelihood.
A lower value indicates a better fit.
}
\description{
This function calculates the likelihood (or more precisely, a penalized negative log-likelihood)
for the Generalized L-moments estimation of the Generalized Extreme Value (GEV) distribution.
}
\details{
The function performs the following steps:
1. Checks if the parameters are within valid ranges.
2. Calculates the expected L-moments based on the current parameters.
3. Computes the difference between expected and sample L-moments.
4. Calculates the generalized L-moments distance.
5. Applies a penalization term based on the specified method.
6. Returns the sum of the L-moments distance and the penalization term.
}
\examples{
data(streamflow)
x <- streamflow$r1
slm <- lmomco::lmoms(x, nmom = 3)
cov_mat <- lmomco::lmoms.cov(x, nmom = 3)
lme_par <- lmomco::pargev(slm)$para
glme.like(par = lme_par, xdat = x, slmgev = slm,
          covinv = solve(cov_mat), lcovdet = log(det(cov_mat)),
          mu = -0.5, std = 0.2, lme = lme_par, pen = "beta",
          p = 6, c1 = 10, c2 = 5)

}
\references{
Shin, Y., Shin, Y., Park, J. & Park, J.-S. (2025). Generalized method of
L-moment estimation for stationary and nonstationary extreme value models.
arXiv preprint arXiv:2512.20385. \doi{10.48550/arXiv.2512.20385}
}
\seealso{
\code{\link{glme.gev}} which calls this function for optimization.
}
\author{
Yonggwan Shin, Seokkap Ko, Jihong Park, Yire Shin, Jeong-Soo Park
}
