% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glme.gev11.R
\name{glme.gev11}
\alias{glme.gev11}
\title{Generalized L-moments estimation for non-stationary GEV11 model}
\usage{
glme.gev11(
  xdat,
  ntry = 10,
  ftol = 1e-06,
  init.rob = TRUE,
  glme.pre = "wls",
  opt.choose = "gof",
  pen = "beta",
  pen.choice = NULL,
  mu = -0.55,
  std = 0.3,
  p = 6,
  c1 = 10,
  c2 = 5
)
}
\arguments{
\item{xdat}{A numeric vector of data to be fitted.}

\item{ntry}{Number of attempts for parameter estimation (default 10).}

\item{ftol}{Tolerance for convergence (default 1e-6).}

\item{init.rob}{Use robust regression for initialization (default TRUE).}

\item{glme.pre}{Pre-estimation method: "wls" (default) or "gado".}

\item{opt.choose}{Selection criterion: "gof" (default, goodness-of-fit) or "nllh" (negative log-likelihood).}

\item{pen}{Type of penalty function: "norm", "beta" (default), "ms", "park", "cannon", "cd", or "no".}

\item{pen.choice}{Choice number for penalty hyperparameters (default 6 for beta).}

\item{mu}{Mean for normal penalty (default -0.55).}

\item{std}{Std for normal penalty (default 0.3).}

\item{p}{Shape for beta penalty (default 6).}

\item{c1}{Scaling for beta penalty (default 10).}

\item{c2}{Limit for beta penalty (default 5).}
}
\value{
A list containing:
\itemize{
  \item para.glme - Proposed GLME estimates (5 parameters: mu0, mu1, sigma0, sigma1, xi).
  \item para.lme - L-moment based estimates for non-stationary model.
  \item para.gado - GN16 original estimates.
  \item para.wls - Weighted least squares estimates (WLS).
  \item strup.org - WLSE by strup method.
  \item lme.sta - Stationary L-moment estimates.
  \item pen - Penalty method used.
  \item p_q - (for beta) p and q values.
  \item c1_c2 - (for beta) c1 and c2 values.
}
}
\description{
This function estimates parameters of the non-stationary GEV11 model
where mu(t) = mu0 + mu1*t and sigma(t) = exp(sigma0 + sigma1*t).
}
\examples{
# Load example streamflow data
data(streamflow)
x <- streamflow$r1

\donttest{
# Estimate non-stationary GEV11 parameters
result <- glme.gev11(x, ntry = 5)
print(result$para.glme)  # Proposed GLME estimates
print(result$para.lme)  # L-moment based estimates
}

}
\references{
Shin, Y., Shin, Y., Park, J. & Park, J.-S. (2025). Generalized method of
L-moment estimation for stationary and nonstationary extreme value models.
arXiv preprint arXiv:2512.20385. \doi{10.48550/arXiv.2512.20385}

Shin, Y., Shin, Y. & Park, J.-S. (2025). Building nonstationary extreme value
model using L-moments. Journal of the Korean Statistical Society, 54, 947-970.
\doi{10.1007/s42952-025-00325-3}
}
\seealso{
\code{\link{glme.gev}} for stationary GEV estimation,
  \code{\link{nsgev}} for the pure L-moment wrapper (no penalty),
  \code{\link{quagev.NS}} for non-stationary quantile computation.
}
\author{
Yonggwan Shin, Seokkap Ko, Jihong Park, Yire Shin, Jeong-Soo Park
}
