% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/magev_helpers.R
\name{delta.gev}
\alias{delta.gev}
\title{Delta method variance and cross-covariance for GEV quantiles}
\usage{
delta.gev(
  gevf3 = NULL,
  mle3i = NULL,
  cov2i = NULL,
  mle3j = NULL,
  cov2j = NULL,
  quant = NULL,
  d3yes = FALSE
)
}
\arguments{
\item{gevf3}{Full MLE result list with \code{cov} and \code{mle} (used when d3yes=TRUE).}

\item{mle3i}{Parameter vector for submodel i (used when d3yes=FALSE).}

\item{cov2i}{2x2 covariance matrix for submodel i.}

\item{mle3j}{Parameter vector for submodel j.}

\item{cov2j}{2x2 covariance matrix for submodel j.}

\item{quant}{Numeric vector of quantile probabilities.}

\item{d3yes}{Logical. If TRUE, compute 3-parameter delta method variance.}
}
\value{
A list containing:
\describe{
  \item{v3}{Variance for each quantile (if d3yes=TRUE)}
  \item{covij}{Cross-covariance for each quantile (if d3yes=FALSE)}
}
}
\description{
Internal function that computes delta method variances
for GEV quantile estimates. Can compute either the variance from
a full 3-parameter MLE (d3yes=TRUE) or the cross-covariance between
two submodels with fixed xi (d3yes=FALSE).
}
\keyword{internal}
