% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Trehafod}
\alias{Trehafod}
\title{Trehafod River Flow Data}
\format{
A data frame with 53 rows and 2 columns:
\describe{
  \item{Year}{Year of observation (integer, 1968-2021)}
  \item{r1}{Annual maximum river flow in cubic meters per second (m^3/s)}
}
}
\source{
UK National River Flow Archive.
}
\usage{
Trehafod
}
\description{
Annual maximum river flow data from the Trehafod gauging station in Wales, UK.
This dataset is commonly used for demonstrating non-stationary extreme value
analysis methods.
}
\examples{
data(Trehafod)
head(Trehafod)

\donttest{
# Fit non-stationary GEV11 model
result <- glme.gev11(Trehafod$r1, ntry = 5)
print(result$para.glme)
}

}
\references{
Shin, Y., Shin, Y. & Park, J.-S. (2025). Building nonstationary extreme value
model using L-moments. Journal of the Korean Statistical Society, 54, 947-970.
\doi{10.1007/s42952-025-00325-3}
}
\keyword{datasets}
