library(GGIR)
context("Lux handling in part 5")
test_that("lux_per_segment is correctly calculated", {
  skip_on_cran()
  
  # This test also covers: dayborder != 0 and part5_agg2_60seconds = TRUE
  
  # test data -----
  create_test_acc_csv(Nmin=1440*2)
  fn = "123A_testaccfile.csv"
  dn = "output_test"
  if (file.exists(dn)) unlink(dn, recursive = TRUE)
  
  # run part 1
  GGIR(mode = 1, datadir = fn, outputdir = getwd(), studyname = "test",
       do.report = c(), dayborder = 23, verbose = FALSE, nonwear_approach = "2013")
  
  # add lightmean and lightpeak to metalong
  meta_fn = paste(getwd(), "output_test", "meta", "basic", 
                  "meta_123A_testaccfile.csv.RData", sep = .Platform$file.sep)
  load(meta_fn)
  set.seed(400)
  M$metalong$lightmean = rnorm(n = nrow(M$metalong),mean=1000,sd=2000)
  M$metalong$lightmean[which(M$metalong$lightmean < 0)] = 0
  M$metalong$lightmean = M$metalong$lightmean / 1000
  M$metalong$lightpeak = M$metalong$lightmean + 0.2
  
  save(C, I, M, filefoldername, filename_dir, tail_expansion_log,
       file = meta_fn)
  
  # now run parts 2:5
  GGIR(mode = 2:5, datadir = fn, outputdir = getwd(), studyname = "test",
       overwrite = FALSE, do.report = c(2, 4, 5), verbose = FALSE,
       LUXthresholds = c(0, 500, 1000), 
       LUX_cal_constant = 1, 
       LUX_cal_exponent = 0.2, 
       LUX_day_segments = c(9, 15, 24), 
       dayborder = 23, part5_agg2_60seconds = TRUE,
       save_ms5rawlevels = TRUE, save_ms5raw_without_invalid = FALSE,
       save_ms5raw_format = "RData", nonwear_approach = "2013",
       timewindow = "MM")
  
  # Only segment 9 to 15hr is calculated because it is the only segment
  # containing awake data in the file generated by create_test_acc_csv
  
  # tests -----
  p5_fn = paste(getwd(), "output_test", "results", 
                "part5_daysummary_MM_L40M100V400_T5A5.csv",
                sep = .Platform$file.sep)
  df = read.csv(p5_fn)
  
  expect_equal(length(which(grepl("^LUX", colnames(df)))), 17) # max and mean day, mean spt, mean mvpa, and ranges ()
  expect_equal(df$LUX_max_day, 3.3)
  expect_equal(df$LUX_mean_day, 2)
  expect_equal(df$LUX_mean_day_mvpa, 2.7)
  expect_equal(df$LUX_min_0_500_day, df$dur_day_min) #in this artificial data, all LUX values in the day are expected to be below 500
  
  # dayborder and ws3 = 60
  p5raw_fn = paste(getwd(), "output_test", "meta", 
                   "ms5.outraw", "40_100_400",
                   "123A_testaccfile_T5A5.RData",
                   sep = .Platform$file.sep)
  expect_true(file.exists(p5raw_fn))
  mdat = c()
  load(p5raw_fn)
  expect_equal(diff(mdat[1:2, "timenum"]), 60) #epoch = 60
  pm11 = grep("23:00:00", as.character(mdat$timestamp))[1]
  expect_equal(diff(mdat[(pm11 - 1):pm11, "window"]), 1) #dayborder = 23 (change in window at 23:00)
  
  outfolder = paste(getwd(), "output_test", sep = .Platform$file.sep)
  if (file.exists(outfolder))  unlink(outfolder, recursive = TRUE)
  if (file.exists(dn)) unlink(dn, recursive = TRUE)
  if (file.exists(fn)) unlink(fn, recursive = TRUE)
})
