% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulate_MET_data.R
\name{Simulate_MET_data}
\alias{Simulate_MET_data}
\title{Simulate multi-environment trials data}
\usage{
Simulate_MET_data(Design, K, h2 = 0.5, rho = 0.5, sd_mu = 1)
}
\arguments{
\item{Design}{a data frame with two columns: "Genotype" for genotype names and
"Environment" for environment names. All genotypes names must be included
in the set of row/column names of the "K" matrix. The number of environments (J)
must be at least two}

\item{K}{a square kinship or genomic relationship matrix for N genotypes
whose row/column names include those of the "Genotype" column of
the "Design" matrix}

\item{h2}{heritability (numeric value between 0 and 1 excluded) of observations
in each environment: either a scalar to set a common heritability for all
environments, or a vector of heritabilities associated with each environment
of size J. The default value is a heritability of 0.5 for all environments}

\item{rho}{genetic correlation (numeric value between -1 and 1 excluded)
between environment pairs: either a scalar to set a common genetic correlation
between all environment pairs, or a square correlation matrix of dimension JxJ.
The default value is a genetic correlation of 0.5 between all environment pairs}

\item{sd_mu}{standard deviation (positive numeric value) of the Gaussian
distribution in which environment means are drawn. The default value is 1}
}
\value{
a list of two elements: a "Pheno" data frame consisting of the
"Design" data frame to which a "Y" column containing simulated phenotypic
values has been added, and a "EnvBV" matrix of dimension NxJ containing the
simulated environment-specific breeding values
}
\description{
This function calculates the best linear unbiased prediction
and the conditional variance matrix of environment-specific breeding values
}
\examples{
## Set seed for reproductibility
set.seed(123)

## Load "wheat" dataset from BGLR
data("wheat",package = "BGLR")

## Generate a design data frame for all genotypes in 5 environments
Design <- expand.grid(Genotype=rownames(wheat.A),Environment=paste0("Env",1:5))

## Set sparseness by discarding 75\% of the combinations
Design <- Design[-sample(nrow(Design),round(nrow(Design)*3/4)),]

## Simulate phenotypic data with default parameter values
DataSim <- Simulate_MET_data(Design=Design,K=wheat.A)

## Simulated phenotypes
head(DataSim$Pheno)

## Simulated environment-specific breeding values
head(DataSim$EnvBV)

## Genetic covariance matrix between environments
DataSim$Omega_G

## Error covariance matrix between environments
DataSim$Omega_E

}
