% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/within_trial_change.R
\name{within_trial_change}
\alias{within_trial_change}
\title{Get mean activity change within a trial}
\usage{
within_trial_change(Dataframe, Trial, Beg.period = FALSE,
  End.period = FALSE)
}
\arguments{
\item{Dataframe}{a GCalcium-format data frame or matrix}

\item{Trial}{a single trial number}

\item{Beg.period}{time frame of period 1 to be compared to period 2}

\item{End.period}{time frame of period 2 to be compared to period 1}
}
\value{
vector with AUC for each curve in a trial
}
\description{
`within_trial_change` finds the change in mean values between beginning and end of entered time range.
}
\examples{
# In trial 1, how much did the mean value change between -2s and 0s, and 0 and 2s?
df.new <- format_data(data = GCaMP)
within_trial_change(Dataframe = df.new, Trial = 1, Beg.period = c(-2, 0), End.period = c(0, 2))
}
