% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moz_ts.R
\docType{data}
\name{moz_ts}
\alias{moz_ts}
\title{Worldbank time series data for Mozambique}
\format{
A \code{ts} object containing:
\describe{
  \item{year}{Year to which data refers}
  \item{CO2}{CO2 emissions (metric tons per capita); Data from: IDA Results
  Measurement System, Tier I Database – WDI;}
  \item{EPC}{Electric power consumption (kWh per capita). Data from database:
  Jobs;}
  \item{EU}{Energy use (kg of oil equivalent per capita). Data from database:
  World Development Indicators;}
  \item{GDP}{Gross domestic product per capita (current US$); Data from: World Development
  Indicators.}
}
}
\usage{
moz_ts
}
\description{
Mozambique's CO2, GDP, EPC e EU time series (1991-2014) from
\url{https://databank.worldbank.org/} (Downloaded in 2024/12/03).
}
\examples{
data(moz_ts)

plot(moz_ts)
}
\keyword{datasets}
