#' @exportS3Method simulate default
simulate.default <- function(n, omega, alpha, beta, delta = 2, X, pi, shock.distr = "Normal", valinit = 200){
  #if(!is.matrix(X)){
  #  X <- as.matrix(X)
  #} # End if
  d <- length(pi)

  # # Minimum of alpha, beta, and pi
  # n2 <- n + max(length(alpha), length(beta)) + 1

  if(dim(X)[1] != (n +  valinit)){
    stop("Number of rows of X should be n + valinit")
  } # End if

  if(any(is.na(alpha)) || is.null(alpha)){
    alpha = 0
  } # End if

  if(any(is.na(beta)) || is.null(beta)){
    beta = 0
  } # End if

  if(length(pi) != dim(X)[2]){
    stop("Dimension of X must match dimension of pi")
  } #

  if (!(shock.distr %in% c("Normal", "t5", "t7", "Laplace"))){
    stop("shock.distr must be Normal, t5, t7, or Laplace")
  } #

    # Create eps: Time series
  #####################################################################################################################################

  # Calculate how many exogenous covariates
  num_param <- max(length(alpha), length(beta), length(pi))
  p <- length(alpha)
  q <- length(beta)
  
  #valinit <- valinit - max(length(alpha), length(beta), length(pi))
  
  # Simulate random white noise
  if (shock.distr == "Normal")
    eta <- rnorm(n+valinit)
  else if (shock.distr == "t5")
    eta <- rt(n+valinit,df = 5)
  else if (shock.distr == "t7")
    eta <- rt(n+valinit,df = 7)

  # Initialize vectors h, sigma, and eps as vectors of 0s
  h <- rep(0, n+valinit)
  sigma <- h
  eps <- h
  
  # Equation #2 in Francq and Thieu
  # ε_t = h^{1/δ_0}_t * η_t
  # For 1:d
  h[1:num_param] <- omega
  # h^{1/δ_0}_t
  sigma[1:num_param] <- h[1:num_param]^(1/delta)
  # Product of h^{1/δ_0}_t and η_t, which becomes ε_t
  eps[1:num_param] <- sigma[1:num_param] * eta[1:num_param]
  
  # Equation #2 in Francq and Thieu
  #  ht=ω0+ qi=1 α0i+(ε+t−i)δ0+α0i−(ε− t−i)δ0 + pj=1β0jht−j+π′0xt−1
  for(t in (num_param+1):(n+valinit)){
    h[t] <- omega + sum(alpha * (eps[(t-1):(t-p)])^delta) + sum(beta * h[(t-1):(t-q)]) + drop(t(pi) %*% X[t-1,])
    sigma[t] <- h[t]^(1/delta)
    eps[t] <- sigma[t] * eta[t]
  } # End for
  
  
  
  
  
  # Create labeled list as a return value
  i <- valinit + 1
  j <- valinit + n

  eps <- eps[i:j]
  X <- X[i:j,]
  #eps <- eps[(d+1):(d+n)]

  sim_data <- list(eps = eps, X = X)

  return(sim_data)
} # End simulate.GARCHXselect
