#' @export
#' @keywords internal
predict.GARCHX <- function(model, X, n_pred){
  # Extract coefficient values of omega, alpha, beta, and pi
  omega <- model$omega
  alpha <- model$alpha
  beta <- model$beta
  pi <- model$pi
  p <- length(alpha)
  q <- length(beta)

  # ### First Way ###
  # Requires parameters: model, new_X, n_pred only
  eps <- model$eps
  # Error check
  if(dim(X)[1] != n_pred){
    stop("Number of rows for X must equal n_pred")
  } # End if

  # Extract exogenous covariates that were selected by the model
  X <- X[, model$selectedX_index]
  X <- rbind(model$selectedX, as.matrix(X, ncol = length(model$selectedX_index)))
  # ### END ###



  # Initialize h as a vector of zeros with size n_pred
  h <- rep(0, n_pred)

  # Calculate the current time by finding length of time series
  current_time <- length(eps)

  t = 1
  if(length(pi) == 1 && is.na(pi))
  {

    sigma2_t <- omega + alpha * eps[current_time - 1] + beta * eps[current_time - 1]

    h[1] <- max(0, omega + alpha * eps[current_time] + beta * sigma2_t)

    for(t in 2:n_pred){
      h[t] <- max(0.01, omega + sum(alpha * h[(t-1):(t-p)]) + sum(beta * h[(t-1):(t-q)]))
    } # End for
  } else 
  {
    sigma2_t <- omega + alpha * eps[current_time - 1] + beta * eps[current_time - 1] + drop(X[current_time-1,] %*% pi)

    h[1] <- max(0, omega + alpha * eps[current_time] + beta * sigma2_t + drop(X[current_time,] %*% pi))

    for(t in 2:n_pred)
      h[t] <- max(0.01, omega + sum(alpha * h[(t-1):(t-p)]) + sum(beta * h[(t-1):(t-q)]) + drop(X[current_time + t - 1, ] %*% pi))
  } # End if


  # Return sigma^2
  return(h)
} # End predict.GARCHX
