#' @export
#' @keywords internal
BIC.GARCHX <- function(model){
  # Calculate initial value of sigma^2
  #sigma2.init <- mean(model$eps[1:model$r]^2)
  sigma.init <- mean(model$eps[1:model$r]^model$delta)

  # Calculate epsilon^delta
  eps.delta <- model$eps^model$delta

  # Check if the model is a GARCHX or GARCH model
  if(is.na(model$pi[1])){
    null = FALSE
  } else {
    null = TRUE
  } # End if-else

  # Calculate QMLE of GARCHX model
  # QMLE <- Likelihood(model, sigma.init = sigma.init, length(model$eps),
  #                    eps.delta = eps.delta, null = null)
  # Should nlminb be used here?

  p <- model$order[1]
  q <- model$order[2]
  # Calculate BIC of model
  BIC <- 2 * length(model$eps) * model$Likelihood + (1 + p + q + model$d) * log(length(model$eps))

  return(BIC)
} # End BIC.GARCHX
