% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-compare.R
\docType{methods}
\name{possibilityStrictExceedance}
\alias{possibilityStrictExceedance}
\alias{possibilityStrictExceedance,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}
\title{Possibility of strict exceedance}
\usage{
\S4method{possibilityStrictExceedance}{PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber}(e1, e2)
}
\arguments{
\item{e1}{a PiecewiseLinearFuzzyNumber}

\item{e2}{a PiecewiseLinearFuzzyNumber}
}
\value{
Returns a value from range [0,1] indicating the strict 
possibility of exceedance of e2 by e1.
}
\description{
Determines value of possibility of \eqn{e1>e2}, the result is from
range [0,1]. Value 0 indicates no fulfilment of the operator
and 1 indicates complete fulfilment.
}
\examples{
a <- TriangularFuzzyNumber(2, 3, 5)
b <- TriangularFuzzyNumber(1.5, 4, 4.8)
a <- as.PiecewiseLinearFuzzyNumber(a, knot.n = 9)
b <- as.PiecewiseLinearFuzzyNumber(b, knot.n = 9)
possibilityStrictExceedance(a,b)
}
\references{
DUBOIS, Didier and PRADE, Henri, 1983, Ranking Fuzzy Numbers in the Setting of Possibility Theory. Information Sciences. 1983. Vol. 30, no. 3, p. 183--224.
}
\seealso{
Other comparison-operators: 
\code{\link{necessityExceedance}()},
\code{\link{necessityStrictExceedance}()},
\code{\link{necessityStrictUndervaluation}()},
\code{\link{necessityUndervaluation}()},
\code{\link{possibilityExceedance}()},
\code{\link{possibilityStrictUndervaluation}()},
\code{\link{possibilityUndervaluation}()}

Other PiecewiseLinearFuzzyNumber-method: 
\code{\link{Arithmetic}},
\code{\link{Extract}},
\code{\link{PiecewiseLinearFuzzyNumber-class}},
\code{\link{PiecewiseLinearFuzzyNumber}},
\code{\link{^,PiecewiseLinearFuzzyNumber,numeric-method}},
\code{\link{alphaInterval}()},
\code{\link{arctan2}()},
\code{\link{as.PiecewiseLinearFuzzyNumber}()},
\code{\link{as.PowerFuzzyNumber}()},
\code{\link{as.TrapezoidalFuzzyNumber}()},
\code{\link{as.character}()},
\code{\link{expectedInterval}()},
\code{\link{fapply}()},
\code{\link{maximum}()},
\code{\link{minimum}()},
\code{\link{necessityExceedance}()},
\code{\link{necessityStrictExceedance}()},
\code{\link{necessityStrictUndervaluation}()},
\code{\link{necessityUndervaluation}()},
\code{\link{plot}()},
\code{\link{possibilityExceedance}()},
\code{\link{possibilityStrictUndervaluation}()},
\code{\link{possibilityUndervaluation}()}
}
\concept{PiecewiseLinearFuzzyNumber-method}
\concept{comparison-operators}
