% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-as.TrapezoidalFuzzyNumber.R
\docType{methods}
\name{as.TrapezoidalFuzzyNumber}
\alias{as.TrapezoidalFuzzyNumber}
\alias{as.TrapezoidalFuzzyNumber,numeric-method}
\alias{as.TrapezoidalFuzzyNumber,FuzzyNumber-method}
\alias{as.TrapezoidalFuzzyNumber,TrapezoidalFuzzyNumber-method}
\alias{as.TrapezoidalFuzzyNumber,PowerFuzzyNumber-method}
\alias{as.TrapezoidalFuzzyNumber,PiecewiseLinearFuzzyNumber-method}
\title{Converts an Object to a Trapezoidal Fuzzy Number}
\usage{
\S4method{as.TrapezoidalFuzzyNumber}{numeric}(object)

\S4method{as.TrapezoidalFuzzyNumber}{FuzzyNumber}(object)

\S4method{as.TrapezoidalFuzzyNumber}{PowerFuzzyNumber}(object)

\S4method{as.TrapezoidalFuzzyNumber}{PiecewiseLinearFuzzyNumber}(object)

\S4method{as.TrapezoidalFuzzyNumber}{TrapezoidalFuzzyNumber}(object)
}
\arguments{
\item{object}{a fuzzy number or a single numeric value (crisp number)
or vector of length two (interval)}
}
\value{
Returns an bject of class \code{\linkS4class{TrapezoidalFuzzyNumber}}.
}
\description{
This method is only for exact conversion.
For other cases (e.g. general FNs), use
\code{\link{trapezoidalApproximation}}.
}
\seealso{
Other FuzzyNumber-method: 
\code{\link{Arithmetic}},
\code{\link{Extract}},
\code{\link{FuzzyNumber-class}},
\code{\link{FuzzyNumber}},
\code{\link{alphaInterval}()},
\code{\link{alphacut}()},
\code{\link{ambiguity}()},
\code{\link{as.FuzzyNumber}()},
\code{\link{as.PiecewiseLinearFuzzyNumber}()},
\code{\link{as.PowerFuzzyNumber}()},
\code{\link{as.character}()},
\code{\link{core}()},
\code{\link{distance}()},
\code{\link{evaluate}()},
\code{\link{expectedInterval}()},
\code{\link{expectedValue}()},
\code{\link{integrateAlpha}()},
\code{\link{piecewiseLinearApproximation}()},
\code{\link{plot}()},
\code{\link{show}()},
\code{\link{supp}()},
\code{\link{trapezoidalApproximation}()},
\code{\link{value}()},
\code{\link{weightedExpectedValue}()},
\code{\link{width}()}

Other TrapezoidalFuzzyNumber-method: 
\code{\link{Arithmetic}},
\code{\link{TrapezoidalFuzzyNumber-class}},
\code{\link{TrapezoidalFuzzyNumber}},
\code{\link{TriangularFuzzyNumber}()},
\code{\link{alphaInterval}()},
\code{\link{as.PiecewiseLinearFuzzyNumber}()},
\code{\link{as.PowerFuzzyNumber}()},
\code{\link{expectedInterval}()},
\code{\link{plot}()}

Other PowerFuzzyNumber-method: 
\code{\link{Extract}},
\code{\link{PowerFuzzyNumber-class}},
\code{\link{PowerFuzzyNumber}},
\code{\link{alphaInterval}()},
\code{\link{as.PowerFuzzyNumber}()},
\code{\link{as.character}()},
\code{\link{expectedInterval}()}

Other PiecewiseLinearFuzzyNumber-method: 
\code{\link{Arithmetic}},
\code{\link{Extract}},
\code{\link{PiecewiseLinearFuzzyNumber-class}},
\code{\link{PiecewiseLinearFuzzyNumber}},
\code{\link{^,PiecewiseLinearFuzzyNumber,numeric-method}},
\code{\link{alphaInterval}()},
\code{\link{arctan2}()},
\code{\link{as.PiecewiseLinearFuzzyNumber}()},
\code{\link{as.PowerFuzzyNumber}()},
\code{\link{as.character}()},
\code{\link{expectedInterval}()},
\code{\link{fapply}()},
\code{\link{maximum}()},
\code{\link{minimum}()},
\code{\link{necessityExceedance}()},
\code{\link{necessityStrictExceedance}()},
\code{\link{necessityStrictUndervaluation}()},
\code{\link{necessityUndervaluation}()},
\code{\link{plot}()},
\code{\link{possibilityExceedance}()},
\code{\link{possibilityStrictExceedance}()},
\code{\link{possibilityStrictUndervaluation}()},
\code{\link{possibilityUndervaluation}()}

Other conversion: 
\code{\link{as.FuzzyNumber}()},
\code{\link{as.PiecewiseLinearFuzzyNumber}()},
\code{\link{as.PowerFuzzyNumber}()},
\code{\link{as.character}()}
}
\concept{FuzzyNumber-method}
\concept{PiecewiseLinearFuzzyNumber-method}
\concept{PowerFuzzyNumber-method}
\concept{TrapezoidalFuzzyNumber-method}
\concept{conversion}
