test_that("t norm reverse works", {
  expect_equal(get_tnorm_reverse('Min'), "min_tnorm_reverse")
  expect_equal(get_tnorm_reverse("Einstein Product"), "einstein_product_tnorm_reverse")
  expect_equal(get_tnorm_reverse("Hamacher Product"), "hamacher_product_tnorm_reverse")
  expect_equal(get_tnorm_reverse("Algebraic Product"), "algebraic_product_tnorm_reverse")
  expect_equal(get_tnorm_reverse("Bounded Difference"), "bounded_difference_tnorm_reverse")
  expect_equal(get_tnorm_reverse("Drastic Product"), "drastic_product_tnorm_reverse")
  expect_equal(get_tnorm_reverse("Parameterized mean intersection operator"), "parameterized_mean_intersection_operator_tnorm_reverse")
  expect_equal(get_tnorm_reverse("Dubois-intersection operator"), "dubois_intersection_operator_tnorm_reverse")
  expect_equal(get_tnorm_reverse("Hamacher-intersection operator"), "hamacher_intersection_operator_tnorm_reverse")
  expect_equal(get_tnorm_reverse("Yager-intersection operator"), "yager_intersection_operator_tnorm_reverse")

  expect_equal(min_tnorm_reverse(1,5), 1)
  expect_equal(hamacher_product_tnorm_reverse(4,2), -4)
  expect_equal(algebraic_product_tnorm_reverse(1,3), 1)
  expect_equal(einstein_product_tnorm_reverse(2,4), 2)
  expect_equal(bounded_difference_tnorm_reverse(3,5), -1)
  expect_equal(drastic_product_tnorm_reverse(1,4), 1)
  expect_equal(drastic_product_tnorm_reverse(1,0), 0.999)
  expect_equal(parameterized_mean_intersection_operator_tnorm_reverse(1,4, gammaTnormMean = 0), 2.5)
  expect_equal(dubois_intersection_operator_tnorm_reverse(1,4, algaTnorm = 0), 1)
  expect_equal(hamacher_intersection_operator_tnorm_reverse(1,3, gammaTnorm = 0), 3)
  expect_equal(yager_intersection_operator_tnorm_reverse(1,4,piTnorm = 0), 1)

})
