% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DatPopM.R
\docType{data}
\name{DatPopM}
\alias{DatPopM}
\title{Database of auxiliary information for the whole population of students}
\format{\describe{
   \item{Ses}{An ordinal factor with three categories (low, middle and high) indicating the socio-economical status of the student.}
   \item{Read}{A number indicating the mark of the student in a reading test.}
   \item{Write}{A number indicating the mark of the student in a writing test.}
   \item{Domain}{A string indicating the domain each student belongs to. Possible values are "a" if student belongs to domain a, "b" if student belongs to domain b or "ab" if student belongs to overlap domain.}
}}
\usage{
DatPopM
}
\description{
This dataset contains population information about the auxiliary variables of the population of students
}
\details{
The population size is \eqn{N = 10000}.
}
\examples{
data(DatPopM)
attach(DatPopM)
#Let perform a brief descriptive analysis for the three auxiliary variables
summary (Ses)
summary(Read)
summary(Write)
}
\seealso{
\code{\link{DatMA}} \code{\link{DatMB}}
}
\keyword{datasets}

