% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DrugFormulation.R
\name{boxplot}
\alias{boxplot}
\title{Generate boxplot}
\usage{
boxplot(formulation_data, x, y)
}
\arguments{
\item{formulation_data}{A data frame containing the formulation data.}

\item{x}{The name of the grouping variable.}

\item{y}{The name of the variable.}
}
\value{
A boxplot.
}
\description{
This function generates a boxplot to compare the distribution of a variable across different groups.
}
\examples{
formulation_data <- data.frame(
  Formulation_Type = sample(c("Type A", "Type B"), 100, replace = TRUE),
  Drug_Release = rnorm(100, mean = 50, sd = 10)
)
boxplot(formulation_data, "Formulation_Type", "Drug_Release")
}
