% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DrugFormulation.R
\name{anova_analysis}
\alias{anova_analysis}
\title{Perform ANOVA analysis}
\usage{
anova_analysis(formulation_data)
}
\arguments{
\item{formulation_data}{A data frame containing the formulation data.}
}
\value{
A summary of the ANOVA analysis results.
}
\description{
This function conducts analysis of variance (ANOVA) to assess the impact of formulation parameters on key response variables.
}
\examples{
formulation_data <- data.frame(
  Excipient_Concentration = runif(100, min = 0, max = 1),
  Drug_Release = rnorm(100, mean = 50, sd = 10),
  Particle_Size = rnorm(100, mean = 100, sd = 20)
)
anova_analysis(formulation_data)
}
