% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Xw_maineffects_self.R
\name{Xw_maineffects_self}
\alias{Xw_maineffects_self}
\title{function for calculating X=h(x) and w=nu(beta^T h(x)) given a design point x = (x1,...,xd)^T}
\usage{
Xw_maineffects_self(x, b, link = "logit", h.func = NULL)
}
\arguments{
\item{x}{x=(x1,...,xd) -- design point/experimental setting}

\item{b}{b=(b1,...,bp) -- assumed parameter values}

\item{link}{link = "logit"  -- link function, default: "logit", other links: "probit", "cloglog", "loglog", "cauchit", "log", and "identity"}

\item{h.func}{function h(x)=(h1(x),...,hp(x)), default (1,x1,...,xd)}
}
\value{
X=h(x)=(h1(x),...,hp(x)) -- a row for design matrix

w -- nu(b^t h(x))

link -- link function applied
}
\description{
function for calculating X=h(x) and w=nu(beta^T h(x)) given a design point x = (x1,...,xd)^T
}
\examples{
# y -> h(y)=(y1,y2,y3,y4,y5,y4*y5,1) in hfunc
hfunc.temp = function(y) {c(y,y[4]*y[5],1);};
link.temp="logit"
x.temp = c(25,1,1,1,1)
b.temp = c(-7.533386, 1.746778, -0.1937022, -0.09704664, 0.1077859, 0.2729715, 0.4293171)
Xw_maineffects_self(x.temp, b.temp, link=link.temp, h.func=hfunc.temp)

}
