% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{objective_func}
\alias{objective_func}
\title{Objective function for robust parameter estimation (RPE)}
\usage{
objective_func(parameters, Var_ests)
}
\arguments{
\item{parameters}{Numeric vector of length three, containing the parameters
\eqn{(\sigma_{\eta}^2, \sigma_{\nu}^2, \phi)} to be estimated.}

\item{Var_ests}{Numeric vector of empirical variance estimates
\eqn{\{v^{(l)}\}_{l=1}^L} obtained from the \eqn{l}-lagged differences of the data.}
}
\value{
A numeric scalar representing the objective value.
}
\description{
Computes the objective value minimized in the robust parameter estimation
(RPE) procedure.
}
\details{
For each lag \eqn{l = 1, \ldots, L}, the theoretical variance of the
\eqn{l}-lagged difference
\eqn{z^{(l)}_t = y_{t+l} - y_t} is calculated by
\deqn{V_l = l\sigma_{\eta}^2 +
      2\,\sigma_{\nu}^2 \frac{1 - \phi^l}{1 - \phi^2}.}
The function returns the sum of squared deviations between
\eqn{V_l} and the empirical variance estimates \eqn{v^{(l)}}:
\deqn{\sum_{l=1}^L \left(V_l - v^{(l)}\right)^2.}
}
\keyword{internal}
