% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FDinterfaces.R
\name{FD.ternaryplot}
\alias{FD.ternaryplot}
\title{Ternary Plot of a Flexible Dirichlet}
\usage{
FD.ternaryplot(x, zoomed = T, showgrid = T, showdata = T, nlevels = 10)
}
\arguments{
\item{x}{an object of class FDfitted, usually the result of \code{\link{FD.estimation}}.}

\item{zoomed}{if \code{TRUE}, shows only the area where most of the density is concentrated. If \code{FALSE}, shows the whole area of the ternary diagram.}

\item{showgrid}{if \code{TRUE}, shows the axis and the labels. If \code{FALSE}, only the graph is printed.}

\item{showdata}{if \code{TRUE}, prints the data points. If \code{FALSE}, shows only the contour lines.}

\item{nlevels}{approximate number of contour lines to be drawn.}
}
\description{
Ternary plot and contour lines of the density function of a fitted Flexible Dirichlet distribution.
}
\details{
The number of variables in the fitted model must be 3 to draw a ternary plot.
}
\examples{
data <- FD.generate(n=20,a=c(12,7,15),p=c(0.3,0.4,0.3),t=8)
data
results <- FD.estimation(data, normalize=TRUE,iter.initial.SEM = 5,iter.final.EM = 10)
results
FD.ternaryplot(results)
FD.ternaryplot(results, zoomed=FALSE, showgrid=TRUE, showdata=FALSE, nlevels=3)

}
\references{
{
 Ongaro, A. and Migliorati, S. (2013) A generalization of the Dirichlet distribution. Journal of Multivariate Analysis, \bold{114}, 412--426.\cr
\cr
 Migliorati, S., Ongaro, A. and Monti, G. S. (2016) A structured Dirichlet mixture model for compositional data: inferential and applicative issues. Statistics and Computing, doi:10.1007/s11222-016-9665-y.
}
}
\seealso{
\code{\link{FD.estimation}}, \code{\link{FD.rightplot}}, \code{\link{FD.marginalplot}}
}
