#' Abundance of stream fish species in Parana and Paraguay streams
#'
#' A dataset containing the abundance of stream fish species distributed in streams of 
#' Parana and Paraguay river Basins
#'
#' @format A data frame with 20 rows and 61 variables:
#' @source Article published in Neotropical Ichthyology  \doi{10.1590/1982-0224-2020-0126}
#
"neotropical_comm"

#' List of fish species with occurrence in Afrotropical ecoregion
#'
#' A list of species that occur in basins of
#' Afrotropical ecoregion
#'
#' @format A character vector with 767 species names:
#' @references \url{https://www.nature.com/articles/sdata2017141}
# 
"spp_afrotropic"

#' Data frame with species names needed to assemble the phylogenetic tree
#'
#' A data frame that can be directly used in FishPhyloMaker to obtain a phylogenetic tree
#'
#' @format A data frame with taxonomic classification (species, family and order) of 45 species
#' @references Species that make up the dataset in the paper published in Neotropical Ichthyology  \doi{10.1590/1982-0224-2020-0126}
# 
"taxon_data_PhyloMaker"