% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.FastStepGraph.R
\name{cv.FastStepGraph}
\alias{cv.FastStepGraph}
\title{Searches for the optimal combination of alpha_f and alpha_b parameters using Cross-Validation}
\usage{
cv.FastStepGraph(
  x,
  n_folds = 5,
  alpha_f_min = 0.2,
  alpha_f_max = 0.8,
  b_coef = 0.5,
  n_alpha = 32,
  nei.max = 5,
  data_scale = FALSE,
  data_shuffle = TRUE,
  max.iterations = NULL,
  return_model = FALSE,
  parallel = FALSE,
  n_cores = NULL
)
}
\arguments{
\item{x}{Data matrix (of size n x p).}

\item{n_folds}{Number of folds for the cross-validation procedure (default value 5).}

\item{alpha_f_min}{Minimum threshold value for the cross-validation procedure (default value 0.2).}

\item{alpha_f_max}{Minimum threshold value for the cross-validation procedure  (default value 0.8).}

\item{b_coef}{This parameter applies the empirical rule alpha_b=b_coef*alpha_f during the initial search for the optimal alpha_f parameter while alpha_b remains fixed, after finding optimal alpha_f, alpha_b is varied to find its optimal value. The default value of b_coef is 0.5.}

\item{n_alpha}{Number of elements in the grid for the cross-validation (default value 32).}

\item{nei.max}{Maximum number of variables in every neighborhood (default value 5).}

\item{data_scale}{Boolean parameter (TRUE or FALSE), when to scale data to zero mean and unit variance (default FALSE).}

\item{data_shuffle}{Boolean parameter (default TRUE), when samples (rows of X) must be randomly shuffled.}

\item{max.iterations}{Maximum number of iterations (integer), the defaults values is set to p*(p-1).}

\item{return_model}{Default FALSE. If set to TRUE, at the end of cross-validation, FastStepGraph is called with the optimal parameters alpha_f and alpha_b, returning \code{vareps}, \code{beta}, \code{Edges} and \code{Omega}.}

\item{parallel}{Boolean parameter (TRUE or FALSE), when to run Cross-Validation in parallel using a multicore architecture (default FALSE).}

\item{n_cores}{An 'int' value specifying the number of cores do you want to use if 'parallel=TRUE'. 
If n_cores is not specified, the maximum number of cores on your machine minus one will be set automatically.}
}
\value{
A list with the values:
\item{\code{alpha_f_opt}}{the optimal alpha_f value.}
\item{\code{alpha_f_opt}}{the optimal alpha_f value.}
\item{\code{CV.loss}}{minimum loss.}
If return_model=TRUE, then also returns:
\item{\code{vareps}}{Response variables.}
\item{\code{beta}}{Regression coefficients.}
\item{\code{Edges}}{Estimated set of edges.}
\item{\code{Omega}}{Estimated precision matrix.}
}
\description{
\code{cv.FastStepGraph} implements the cross-validation for the Fast Step Graph algorithm.
}
\examples{
data <- FastStepGraph::SigmaAR(30, 50, 0.4) # Simulate Gaussian Data
res <- FastStepGraph::cv.FastStepGraph(data$X, data_scale=TRUE)
}
\author{
Prof. Juan G. Colonna, PhD. \email{juancolonna@icomp.ufam.edu.br}

Prof. Marcelo Ruiz, PhD. \email{mruiz@exa.unrc.edu.ar}
}
