% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomization_inference.R
\name{perm_test}
\alias{perm_test}
\title{Fisher's randomization test for sharp null hypothesis.}
\usage{
perm_test(
  Y_obs,
  alloc_obs,
  alloc,
  contrast = c(1, -1),
  tau = 0,
  method = "marginal mean",
  alternative = "not equal"
)
}
\arguments{
\item{Y_obs}{Vector of observed outcome.}

\item{alloc_obs}{Vector of observed treatment assignment.}

\item{alloc}{A matrix of treatment assignments over which the randomization distribution of the test statistic
is computed. Each row of \code{alloc} should correspond to an assignment vector.}

\item{contrast}{A vector of the coefficients of the treatment contrast of interest. For example, for estimating the
average treatment effect of treatment 1 versus treatment 2, \code{contrast = c(1,-1)}.}

\item{tau}{The value of the treatment contrast specified by the sharp null hypothesis.}

\item{method}{The method of computing the test statistic. If \code{method = 'marginal mean'}, the test statistic
is \eqn{c_1 \hat{Y}_i(1) + c_2 \hat{Y}_i(2)}, where \eqn{\hat{Y}(z)} 
is the mean of the observed outcome in the group \eqn{Z = z}, for \eqn{z = 0,1}. If \code{method = 'marginal rank'}, 
the test statistic is \eqn{c_1 \hat{Y}_i(1) + c_2 \hat{Y}_i(2)}, 
where \eqn{\hat{Y}(z)} is the mean of the rank of the observed outcome in the group \eqn{Z = z}, for \eqn{z = 0,1}}

\item{alternative}{The type of alternative hypothesis used. For right-sided test, \code{alternative = 'greater'}.
For left-sided test, \code{alternative = 'less'}. For both-sided test, \code{alternative = 'not equal'}.}
}
\value{
A list containing the following items.

\code{test_stat_obs}: The observed value of the test statistic.

\code{test_stat_iter}: A vector of values of the test statistic across repeated randomizations.

\code{p_value}: p-value of the test.
}
\description{
Performs Fisher's randomization test for sharp null hypotheses of the form 
\eqn{H_0: c_1 Y_i(1) + c_2 Y_i(2) - \tau = 0}, for a vector of contrasts \eqn{(c_1, c_2)}.
}
\examples{
# Consider N = 12, n1 = n2 = 6. 
# We test the sharp null of no treatment effect under CRD.
df_sample = data.frame(index = 1:12, x = c(20,30,40,40,50,60,20,30,40,40,50,60))
# True potential outcomes.
Y_1_true = 100 + (df_sample$x - mean(df_sample$x)) + rnorm(12, 0, 4)
Y_2_true = Y_1_true + 50
# Generate the realized assignment under CRD.
fc = crd(data_frame = df_sample, n_treat = 2, treat_sizes = c(6,6), control = FALSE)
Z_crd_obs = fc$Treat
# Get the observed outcomes
Y_obs = Y_1_true
Y_obs[Z_crd_obs == 2] = Y_2_true[Z_crd_obs == 2]
# Generate 1000 assignments under CRD.
Z_crd_iter = matrix(rep(0, 1000 * 12), nrow = 1000)
for(i in 1:1000)
{
fc = crd(data_frame = df_sample, n_treat = 2, treat_sizes = c(6,6), control = FALSE)
Z_crd_iter[i,] = fc$Treat
}
# Test for the sharp null H0: Y_i(1) = Y_i(0) for all i.
# Alternative: not H0 (two-sided test).
perm = perm_test(Y_obs = Y_obs, alloc_obs = Z_crd_obs, alloc = Z_crd_iter, 
contrast = c(1,-1), tau = 0, method = "marginal mean", alternative = 'not equal')
# Obtain the p-value.
perm$p_value
}
\references{
Chattopadhyay, A., Morris, C. N., and Zubizarreta, J. R. (2020), ``Randomized and Balanced Allocation 
of Units into Treatment Groups Using the Finite Selection Model for \code{R}".
}
\author{
Ambarish Chattopadhyay, Carl N. Morris and Jose R. Zubizarreta.
}
