% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsm_without_strata.R
\name{fsm}
\alias{fsm}
\title{Finite Selection Model (FSM)}
\usage{
fsm(
  data_frame,
  SOM,
  s_function = "Dopt",
  Q_initial = NULL,
  eps = 0.001,
  ties = "random",
  intercept = TRUE,
  standardize = TRUE,
  units_print = TRUE,
  index_col = TRUE,
  Pol_mat = NULL,
  w_pol = NULL
)
}
\arguments{
\item{data_frame}{A data frame containing a column of unit indices (optional) and covariates (or transformations thereof).}

\item{SOM}{A selection order matrix.}

\item{s_function}{Specifies a selection function, a string among \code{'constant'}, \code{'Dopt'}, 
\code{'Aopt'}, \code{'max pc'}, \code{'min pc'}, \code{'Dopt pc'}, \code{'max average'}, \code{'min average'},
\code{'Dopt average'}. \code{'constant'} selection function puts a constant value on every unselected unit. 
\code{'Dopt'} use the D-optimality criteria based on the full set of covariates to select units. 
\code{'Aopt'} uses the A-optimality criteria. \code{'max pc'} (respectively, \code{'min pc'}) selects that 
unit that has the maximum (respectively, minimum) value of the first principal component. 
\code{'Dopt pc'} uses the D-optimality criteria on the first principal component, \code{'max average'} 
(respectively, \code{'min average'}) selects that unit that has the maximum (respectively, minimum) 
value of the simple average of the covariates. \code{'Dopt average'} uses the D-optimality criteria on the 
simple average of the covariates.}

\item{Q_initial}{A (optional) non-singular matrix (called 'initial matrix') that is added the \eqn{(X^T X)} 
matrix of the choosing treatment group at any stage, when the \eqn{(X^T X)} matrix of that treatment group
at that stage is non-invertible. If \code{FALSE}, the \eqn{(X^T X)} matrix for the full set of observations is used
as the non-singular matrix. Applicable if \code{s_function = 'Dopt'} or \code{'Aopt'}.}

\item{eps}{Proportionality constant for \code{Q_initial}, the default value is 0.001.}

\item{ties}{Specifies how to deal with ties in the values of the selection function. If \code{ties = 'random'},
a unit is selected randomly from the set of candidate units. If \code{ties = 'smallest'}, the unit 
that appears earlier in the data frame, i.e. the unit with the smallest index gets selected.}

\item{intercept}{if \code{TRUE}, the design matrix of each treatment group includes a column of intercepts.}

\item{standardize}{if \code{TRUE}, the columns of the \eqn{X} matrix other than the column for the intercept (if any), 
are standardized.}

\item{units_print}{if \code{TRUE}, the function automatically prints the candidate units at each step of selection.}

\item{index_col}{if \code{TRUE}, data_frame contains a column of unit indices.}

\item{Pol_mat}{Policy matrix. Applicable only when \code{s_function = 'Aopt'}.}

\item{w_pol}{A vector of policy weights. Applicable only when \code{s_function = 'Aopt'}.}
}
\value{
A list containing the following items.

\code{data_frame_allocated}:  The original data frame augmented with the column of the treatment indicator.

\code{som_appended}:  The SOM with augmented columns for the indices and covariate values for units selected.

\code{som_split}:  som_appended, split by the levels of the treatment.

\code{crit_print}:  The value of the objective function, at each stage of build up process. At each stage, 
the unit that maximizes the objective function is selected.
}
\description{
Generates a randomized assignment of a group of units to multiple groups of pre-determined 
sizes using the Finite Selection Model (FSM).
}
\examples{
# Load the data.
df_sample = data.frame(index = 1:12, x = c(20,30,40,40,50,60,20,30,40,40,50,60))
# Generate an SOM with N = 12, n1 = n2 = 6.
som_sample = som(n_treat = 2, treat_sizes = c(6,6), method = 'SCOMARS', control = TRUE, 
marginal_treat = rep(6/12,12))
# Assign units given the SOM.
f = fsm(data_frame = df_sample, SOM = som_sample, s_function = 'Dopt', 
eps = 0.001, ties = 'random', intercept = TRUE, standardize = TRUE, units_print = TRUE, 
index_col = TRUE)
}
\references{
Chattopadhyay, A., Morris, C. N., and Zubizarreta, J. R. (2020), ``Randomized and Balanced Allocation of 
Units into Treatment Groups Using the Finite Selection Model for \code{R}''.

Morris, C. (1979), ``A finite selection model for experimental design of the health insurance study'',
Journal of Econometrics, 11(1), 43–61.

Morris, C., Hill, J. (2000), ``The health insurance experiment: design using the finite selection model'', 
Public policy and statistics: case studies from RAND, Springer Science & Business Media, 29–53.
}
\author{
Ambarish Chattopadhyay, Carl N. Morris and Jose R. Zubizarreta
}
