% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_funs.R
\name{plot.ame}
\alias{plot.ame}
\title{Plot a summary of FLAME or DAME}
\usage{
\method{plot}{ame}(x, which_plots = c(1, 2, 3, 4), ...)
}
\arguments{
\item{x}{An object of class \code{ame}, returned by a call to
\code{\link{FLAME}} or \code{link{DAME}}.}

\item{which_plots}{A vector describing which plots should be displayed. See
details.}

\item{...}{Additional arguments to passed on to other methods.}
}
\description{
Plot information about numbers of covariates matched on, CATE estimates, and
covariate set dropping order after a call to \code{FLAME} or \code{DAME}.
}
\details{
\code{plot.ame} displays four plots by default. The first contains
information on the number of covariates that matched groups were formed on,
and thereby gives some indication of the quality of matched groups across the
matched data. The second plots matched group sizes against CATEs, which can
be useful for determining whether higher quality matched groups yield
different treatment effect estimates than lower quality ones. The third plots
a density estimate of the estimated CATE distribution. The fourth displays a
heatmap showing which covariates were dropped (shown in black) throughout the
matching procedure.
}
