% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decision_table_wrapper.R
\name{decision_table}
\alias{decision_table}
\title{Generate Decision Tables with S3 Support}
\usage{
decision_table(...)
}
\arguments{
\item{...}{Either design objects (created with \code{design_*} functions) or
legacy arguments (\code{`3+3`}, \code{BOIN}, \code{mTPI2}, \code{i3+3}, \code{G3}).}
}
\value{
A plot showing decision table(s) for the specified design(s).
}
\description{
Enhanced wrapper to generate decision tables that supports both legacy and S3 interfaces.
}
\examples{
# New S3 interface
boin <- design_boin(pT = 0.25, EI = c(0.15, 0.35), npts = 12)
i3 <- design_i3plus3(pT = 0.25, EI = c(0.2, 0.3), npts = 12)

\donttest{
# Generate decision tables
decision_table(boin, i3)
}

# Legacy interface still works
\donttest{
decision_table(
  BOIN = get_decision_boin(pT = 0.25, EI = c(0.15, 0.35), npts = 12),
  `i3+3` = get_decision_i3plus3(pT = 0.25, EI = c(0.2, 0.3), npts = 12)
)
}

}
