% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FFlist.R
\name{FFlist}
\alias{FFlist}
\title{List available datasets on Kenneth French's website}
\usage{
FFlist(exclude_daily = TRUE)
}
\arguments{
\item{exclude_daily}{logical. If \code{TRUE} (default), daily datasets are
excluded from the returned list.}
}
\value{
A data frame (or tibble if the \pkg{tibble} package is available) with
columns:
\describe{
  \item{name}{Dataset name, as used in \code{inputlist} and as key in the
    \code{FFdata} list (without the leading \code{x_} prefix and without the
    \code{_CSV.zip} suffix).}
  \item{file_url}{Full HTTPS URL of the zip file.}
  \item{is_daily}{Logical flag indicating whether the dataset contains daily data.
    Only present when \code{exclude_daily = FALSE}.}
}
}
\description{
\code{FFlist} scrapes Kenneth French's data library and returns a
data frame (or tibble) of available datasets with their names and download URLs.
This replaces the \code{listsave} workaround in \code{\link{FFdownload}} and
makes the dataset inventory directly usable with \code{dplyr::filter()} or
\code{View()}.
}
\examples{
\dontrun{
# Browse all available monthly/annual datasets
fl <- FFlist()
head(fl, 10)

# Include daily datasets
FFlist(exclude_daily = FALSE)

# Filter with dplyr
library(dplyr)
FFlist() |> filter(grepl("Momentum", name))
}

}
