% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplesize.R
\name{n.fdr.oneway}
\alias{n.fdr.oneway}
\title{Sample size calculation for one-way ANOVA}
\usage{
n.fdr.oneway(fdr, pwr, theta, k, pi0.hat = "BH")
}
\arguments{
\item{fdr}{desired FDR (scalar numeric)}

\item{pwr}{desired average power (scalar numeric)}

\item{theta}{sum of ((group mean - overall mean)/stdev)^2 across all groups for each hypothesis test (vector)}

\item{k}{the number of groups to be compared}

\item{pi0.hat}{method to estimate proportion \code{pi0} of tests with true null, including: "HH" (p-value histogram height), "HM" (p-value histogram mean), "BH" (Benjamini & Hochberg 1995), "Jung" (Jung 2005)}
}
\value{
A list with the following components:
\item{n}{per-group sample size estimate}
\item{computed.avepow}{average power}
\item{desired.avepow}{desired average power}
\item{desired.fdr}{desired FDR}
\item{input.pi0}{proportion of tests with a true null hypothesis}
\item{alpha}{fixed p-value threshold for multiple testing procedure}
\item{n.its}{number of iteration}
\item{max.its}{maximum number of iteration, default is 50}
\item{n0}{lower limit for initial sample size range}
\item{n1}{upper limit for initial sample size range}
}
\description{
Find the sample size needed to have a desired false discovery rate and average power for a large number of one-way ANOVA tests.
}
\examples{
theta=rep(c(2,0),c(100,900));
n.fdr.oneway(fdr = 0.1, pwr = 0.8, theta = theta, k = 2, pi0.hat = "BH")
}
